//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit

class RSController: UIViewController{
    
    //MARK:- viewDidLoad()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupScrollView()
        pageSetup()

    }
    
    //MARK:- Page Setup
    
    func pageSetup() {
        
        //MARK:- Navigation Bar
        
        self.navigationItem.title = "Services"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationController?.navigationBar.barStyle = .black
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationItem.rightBarButtonItem = UIBarButtonItem(image:#imageLiteral(resourceName: "logo1").withRenderingMode(.alwaysOriginal), style: .plain , target: self, action: #selector(doNothing))
    
        //MARK:- Service 1
        
        let P1Image = UIImage(named: "S1")
        let P1Button = UIButton()
        let P1Label = UILabel()
        P1Label.frame = CGRect(x: screenWidth/2-125, y: 90, width: 250, height: 30)
        P1Label.textAlignment = NSTextAlignment.center
        P1Label.text = "Raddi Walla"
        P1Label.textColor = .white
        P1Label.font = UIFont.boldSystemFont(ofSize: 32)
        P1Button.frame = CGRect(x: 15, y: 10, width: screenWidth-30, height: 200)
        P1Button.setBackgroundImage(P1Image, for: UIControl.State.normal)
        P1Button.layer.cornerRadius = 15
        P1Button.clipsToBounds = true
        P1Button.addTarget(self, action:#selector(handlePress1), for: .touchUpInside)
        scrollView.addSubview(P1Button)
        scrollView.addSubview(P1Label)
        
        //MARK:- Service 2
        
        let P2Image = UIImage(named: "S2")
        let P2Button = UIButton()
        let P2Label = UILabel()
        P2Label.frame = CGRect(x: screenWidth/2-250, y: 300, width: 500, height: 40)
        P2Label.textAlignment = NSTextAlignment.center
        P2Label.text = "E-Waste Walla"
        P2Label.textColor = .white
        P2Label.font = UIFont.boldSystemFont(ofSize: 32)
        P2Button.frame = CGRect(x: 15, y: 230, width: screenWidth-30, height: 200)
        P2Button.setBackgroundImage(P2Image, for: UIControl.State.normal)
        P2Button.layer.cornerRadius = 15
        P2Button.clipsToBounds = true
        P2Button.addTarget(self, action:#selector(handlePress2), for: .touchUpInside)
        scrollView.addSubview(P2Button)
        scrollView.addSubview(P2Label)
        
        //MARK:- Service 3
               
        let P3Image = UIImage(named: "S3")
        let P3Button = UIButton()
        let P3Label = UILabel()
        P3Label.frame = CGRect(x: screenWidth/2-250, y: 520, width: 500, height: 40)
        P3Label.textAlignment = NSTextAlignment.center
        P3Label.text = "Gardener"
        P3Label.textColor = .white
        P3Label.font = UIFont.boldSystemFont(ofSize: 32)
        P3Button.frame = CGRect(x: 15, y: 450, width: screenWidth-30, height: 200)
        P3Button.setBackgroundImage(P3Image, for: UIControl.State.normal)
        P3Button.layer.cornerRadius = 15
        P3Button.clipsToBounds = true
        P3Button.addTarget(self, action:#selector(handlePress3), for: .touchUpInside)
        scrollView.addSubview(P3Button)
        scrollView.addSubview(P3Label)
        
        //MARK:- Service 4
               
        let P4Image = UIImage(named: "S4")
        let P4Button = UIButton()
        let P4Label = UILabel()
        P4Label.frame = CGRect(x: screenWidth/2-250, y: 740, width: 500, height: 40)
        P4Label.textAlignment = NSTextAlignment.center
        P4Label.text = "Compost Pit"
        P4Label.textColor = .white
        P4Label.font = UIFont.boldSystemFont(ofSize: 32)
        P4Button.frame = CGRect(x: 15, y: 670, width: screenWidth-30, height: 200)
        P4Button.setBackgroundImage(P4Image, for: UIControl.State.normal)
        P4Button.layer.cornerRadius = 15
        P4Button.clipsToBounds = true
        P4Button.addTarget(self, action:#selector(handlePress4), for: .touchUpInside)
        scrollView.addSubview(P4Button)
        scrollView.addSubview(P4Label)
        
        //MARK:- Service 5
               
        let P5Image = UIImage(named: "S5")
        let P5Button = UIButton()
        let P5Label = UILabel()
        P5Label.frame = CGRect(x: screenWidth/2-250, y: 960, width: 500, height: 40)
        P5Label.textAlignment = NSTextAlignment.center
        P5Label.text = "Recycling Machine"
        P5Label.textColor = .white
        P5Label.font = UIFont.boldSystemFont(ofSize: 32)
        P5Button.frame = CGRect(x: 15, y: 890, width: screenWidth-30, height: 200)
        P5Button.setBackgroundImage(P5Image, for: UIControl.State.normal)
        P5Button.layer.cornerRadius = 15
        P5Button.clipsToBounds = true
        P5Button.addTarget(self, action:#selector(handlePress5), for: .touchUpInside)
        scrollView.addSubview(P5Button)
        scrollView.addSubview(P5Label)
        
        //MARK:- Service 6
               
        let P6Image = UIImage(named: "S6")
        let P6Button = UIButton()
        let P6Label = UILabel()
        P6Label.frame = CGRect(x: screenWidth/2-250, y: 1180, width: 500, height: 40)
        P6Label.textAlignment = NSTextAlignment.center
        P6Label.text = "Garbage man "
        P6Label.textColor = .white
        P6Label.font = UIFont.boldSystemFont(ofSize: 32)
        P6Button.frame = CGRect(x: 15, y: 1110, width: screenWidth-30, height: 200)
        P6Button.setBackgroundImage(P6Image, for: UIControl.State.normal)
        P6Button.layer.cornerRadius = 15
        P6Button.clipsToBounds = true
        P6Button.addTarget(self, action:#selector(handlePress6), for: .touchUpInside)
        scrollView.addSubview(P6Button)
        scrollView.addSubview(P6Label)
        
        
    
    }
    
    //MARK:- Page Functions
    
    @objc func handlePress1() {
        let controller = UINavigationController(rootViewController: Service1())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    
    @objc func handlePress2() {
        let controller = UINavigationController(rootViewController: Service2())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress3() {
        let controller = UINavigationController(rootViewController: Service3())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress4() {
        let controller = UINavigationController(rootViewController: Service4())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress5() {
        let controller = UINavigationController(rootViewController: Service5())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    @objc func handlePress6() {
        let controller = UINavigationController(rootViewController: Service6())
        controller.modalPresentationStyle = UIModalPresentationStyle.overCurrentContext
        present(controller, animated:  true, completion: nil)
    }
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
    
    @objc func doNothing(_ sender:UIButton!) {
        
    }
    
    //MARK:- Scroll View
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.translatesAutoresizingMaskIntoConstraints = false
        view.contentSize.height = 1300
        view.backgroundColor = .white
        return view
    }()
    
    func setupScrollView() {
        view.addSubview(scrollView)
        scrollView.topAnchor.constraint(equalTo: view.topAnchor).isActive = true
        scrollView.bottomAnchor.constraint(equalTo: view.bottomAnchor).isActive = true
        scrollView.leftAnchor.constraint(equalTo: view.leftAnchor).isActive = true
        scrollView.rightAnchor.constraint(equalTo: view.rightAnchor).isActive = true
    }
}
class Service1: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    //MARK:- Service 1
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Raddi .jpg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
        let line2 = UIButton()
        line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line2.center = CGPoint(x: screenWidth/2, y: 554)
        line2.backgroundColor = .gray
        line2.layer.cornerRadius = 1
        line2.clipsToBounds = true
        self.view.addSubview(line2)
        
        
        let line4 = UIButton()
        line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
        line4.center = CGPoint(x: screenWidth/2, y: 698)
        line4.backgroundColor = .gray
        line4.layer.cornerRadius = 1
        line4.clipsToBounds = true
        self.view.addSubview(line4)
        
        let phoneNumberImg = UIImage(named: "Name")
        let phoneNumber = UIButton()
        phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
        phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
        phoneNumber.layer.cornerRadius = 20;
        phoneNumber.clipsToBounds = true
        self.view.addSubview(phoneNumber)
        
        let phoneLabel = UILabel()
        phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
        phoneLabel.textAlignment = NSTextAlignment.center
        phoneLabel.text = "Mr. Raju Sharma"
        phoneLabel.textColor = .black
        phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.view.addSubview(phoneLabel)
        
        let emailImg = UIImage(named: "Phone")
        let Email = UIButton()
        Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
        Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
        Email.layer.cornerRadius = 20;
        Email.clipsToBounds = true
        self.view.addSubview(Email)
        
        let emailLabel = UILabel()
        emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
        emailLabel.textAlignment = NSTextAlignment.center
        emailLabel.text = "+91 74101 01333"
        emailLabel.textColor = .black
        emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.view.addSubview(emailLabel)
        
        let AddressImg = UIImage(named: "Name")
        let Address = UIButton()
        Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
        Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
        Address.layer.cornerRadius = 20;
        Address.clipsToBounds = true
        self.view.addSubview(Address)
        
        let AddressLabel = UILabel()
        AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
        AddressLabel.textAlignment = NSTextAlignment.center
        AddressLabel.text = "Mr. Rakesh Gupta"
        AddressLabel.textColor = .black
        AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.view.addSubview(AddressLabel)
        
        let InstaImg = UIImage(named: "Phone")
        let Insta = UIButton()
        Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
        Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
        Insta.layer.cornerRadius = 20;
        Insta.clipsToBounds = true
        self.view.addSubview(Insta)
        
        let instaLabel = UILabel()
        instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
        instaLabel.textAlignment = NSTextAlignment.center
        instaLabel.text = "+91 65745 98765"
        instaLabel.textColor = .black
        instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.view.addSubview(instaLabel)
        
        let TwitterImg = UIImage(named: "Adress")
        let Twitter = UIButton()
        Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
        Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
        Twitter.layer.cornerRadius = 20;
        Twitter.clipsToBounds = true
        self.view.addSubview(Twitter)
        
        let TwitterLabel = UILabel()
        TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
        TwitterLabel.textAlignment = NSTextAlignment.center
        TwitterLabel.text = "At home service"
        TwitterLabel.textColor = .black
        TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
        self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Raddi Walla"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
//MARK:- Service 2
class Service2: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "e-waste ")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
         let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
               
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "Name")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
               phoneLabel.textAlignment = NSTextAlignment.center
               phoneLabel.text = "Mrs. Kusam Kher"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "Phone")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
               emailLabel.textAlignment = NSTextAlignment.center
               emailLabel.text = "+91 99100 55036"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "Name")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
               AddressLabel.textAlignment = NSTextAlignment.center
               AddressLabel.text = "Mr. Navender Singh"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Phone")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
               instaLabel.textAlignment = NSTextAlignment.center
               instaLabel.text = "+91 99901 33388"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "Adress")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
               TwitterLabel.textAlignment = NSTextAlignment.center
               TwitterLabel.text = "At home service"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "E-Waste Walla"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
class Service3: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Gardner")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
               
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "Name")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
               phoneLabel.textAlignment = NSTextAlignment.center
               phoneLabel.text = "Mr. Ravinder Mani"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "Phone")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
               emailLabel.textAlignment = NSTextAlignment.center
               emailLabel.text = "+91 85277 67677"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "Name")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
               AddressLabel.textAlignment = NSTextAlignment.center
               AddressLabel.text = "Mr. Nannu Sethi"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Phone")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
               instaLabel.textAlignment = NSTextAlignment.center
               instaLabel.text = "+91 124626 5000"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "Adress")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
               TwitterLabel.textAlignment = NSTextAlignment.center
               TwitterLabel.text = "At home service"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Gardner"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
class Service4: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "compost.jpg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
         let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
               
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "Name")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
               phoneLabel.textAlignment = NSTextAlignment.center
               phoneLabel.text = "Mr. Sanjeev Kumar"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "Phone")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
               emailLabel.textAlignment = NSTextAlignment.center
               emailLabel.text = "+91 76543 62846"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "Name")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
               AddressLabel.textAlignment = NSTextAlignment.center
               AddressLabel.text = "Mrs. Komal Hari"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Phone")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
               instaLabel.textAlignment = NSTextAlignment.center
               instaLabel.text = "+91 64538 92746"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "Adress")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
               TwitterLabel.textAlignment = NSTextAlignment.center
               TwitterLabel.text = "Behind club house"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Compost Pit"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
class Service5: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Recycling.jpeg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
         let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
               
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "Name")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
               phoneLabel.textAlignment = NSTextAlignment.center
               phoneLabel.text = "Mr. Jasvant Aggarwal"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "Phone")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
               emailLabel.textAlignment = NSTextAlignment.center
               emailLabel.text = "+91 84756 73645"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "Name")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
               AddressLabel.textAlignment = NSTextAlignment.center
               AddressLabel.text = "Mr. Lalu Bansal"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Phone")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
               instaLabel.textAlignment = NSTextAlignment.center
               instaLabel.text = "+91 92356 74657"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "Adress")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
               TwitterLabel.textAlignment = NSTextAlignment.center
               TwitterLabel.text = "Phase 2,T6"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Recycling Machine"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
class Service6: UIViewController{
  
    //MARK:- viewDidLoad
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
    }
    
    //MARK:- Page Setup
    
    func setupView() {
        let card = UILabel(frame: CGRect(x: 20, y: 410, width: screenWidth-40, height: 360))
        card.layer.cornerRadius = 15;
        card.clipsToBounds = true
        card.backgroundColor = .lightGrey()
        self.view.addSubview(card)
        
        let Picture = UIImageView()
        Picture.image = #imageLiteral(resourceName: "Garbage .jpg")
        Picture.frame = CGRect(x: 20, y: 120, width: screenWidth-40, height: 265)
        Picture.layer.cornerRadius = 15;
        Picture.clipsToBounds = true
        self.view.addSubview(Picture)
       
        
        
        let line2 = UIButton()
               line2.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line2.center = CGPoint(x: screenWidth/2, y: 554)
               line2.backgroundColor = .gray
               line2.layer.cornerRadius = 1
               line2.clipsToBounds = true
               self.view.addSubview(line2)
               
               
               let line4 = UIButton()
               line4.frame = CGRect(x: 0, y: 0, width: screenWidth-100, height: 2)
               line4.center = CGPoint(x: screenWidth/2, y: 698)
               line4.backgroundColor = .gray
               line4.layer.cornerRadius = 1
               line4.clipsToBounds = true
               self.view.addSubview(line4)
               
               let phoneNumberImg = UIImage(named: "Name")
               let phoneNumber = UIButton()
               phoneNumber.frame = CGRect(x: 50, y: 430, width: 40, height: 40)
               phoneNumber.setBackgroundImage(phoneNumberImg, for: UIControl.State.normal)
               phoneNumber.layer.cornerRadius = 20;
               phoneNumber.clipsToBounds = true
               self.view.addSubview(phoneNumber)
               
               let phoneLabel = UILabel()
               phoneLabel.frame = CGRect(x: screenWidth/2-240, y: 430, width: 500, height: 40)
               phoneLabel.textAlignment = NSTextAlignment.center
               phoneLabel.text = "Mr. Devanshu Aggarwal"
               phoneLabel.textColor = .black
               phoneLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(phoneLabel)
               
               let emailImg = UIImage(named: "Phone")
               let Email = UIButton()
               Email.frame = CGRect(x: 50, y: 497, width: 40, height: 40)
               Email.setBackgroundImage(emailImg, for: UIControl.State.normal)
               Email.layer.cornerRadius = 20;
               Email.clipsToBounds = true
               self.view.addSubview(Email)
               
               let emailLabel = UILabel()
               emailLabel.frame = CGRect(x: screenWidth/2-240, y: 497, width: 500, height: 40)
               emailLabel.textAlignment = NSTextAlignment.center
               emailLabel.text = "+91 64537 98767"
               emailLabel.textColor = .black
               emailLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(emailLabel)
               
               let AddressImg = UIImage(named: "Name")
               let Address = UIButton()
               Address.frame = CGRect(x: 50, y: 569, width: 40, height: 40)
               Address.setBackgroundImage(AddressImg, for: UIControl.State.normal)
               Address.layer.cornerRadius = 20;
               Address.clipsToBounds = true
               self.view.addSubview(Address)
               
               let AddressLabel = UILabel()
               AddressLabel.frame = CGRect(x: screenWidth/2-240, y: 569, width: 500, height: 40)
               AddressLabel.textAlignment = NSTextAlignment.center
               AddressLabel.text = "Mr. Shyam Goyal"
               AddressLabel.textColor = .black
               AddressLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(AddressLabel)
               
               let InstaImg = UIImage(named: "Phone")
               let Insta = UIButton()
               Insta.frame = CGRect(x: 50, y: 641, width: 40, height: 40)
               Insta.setBackgroundImage(InstaImg, for: UIControl.State.normal)
               Insta.layer.cornerRadius = 20;
               Insta.clipsToBounds = true
               self.view.addSubview(Insta)
               
               let instaLabel = UILabel()
               instaLabel.frame = CGRect(x: screenWidth/2-240, y: 641, width: 500, height: 40)
               instaLabel.textAlignment = NSTextAlignment.center
               instaLabel.text = "+91 76587 98756"
               instaLabel.textColor = .black
               instaLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(instaLabel)
               
               let TwitterImg = UIImage(named: "Adress")
               let Twitter = UIButton()
               Twitter.frame = CGRect(x: 50, y: 713, width: 40, height: 40)
               Twitter.setBackgroundImage(TwitterImg, for: UIControl.State.normal)
               Twitter.layer.cornerRadius = 20;
               Twitter.clipsToBounds = true
               self.view.addSubview(Twitter)
               
               let TwitterLabel = UILabel()
               TwitterLabel.frame = CGRect(x: screenWidth/2-240, y: 713, width: 500, height: 40)
               TwitterLabel.textAlignment = NSTextAlignment.center
               TwitterLabel.text = "At home service"
               TwitterLabel.textColor = .black
               TwitterLabel.font = UIFont(name: "HelveticaNeue-Light", size: 18)
               self.view.addSubview(TwitterLabel)
       
        
        //MARK:- Navigation Bar
        self.navigationItem.title = "Garbage Man"
        navigationController?.navigationBar.barTintColor = .mainBlue()
        navigationItem.leftBarButtonItem = UIBarButtonItem(image: #imageLiteral(resourceName: "Cross").withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(handleDismiss))
        navigationController?.navigationBar.barStyle = .black
        view.backgroundColor = UIColor.black.withAlphaComponent(0.9)
        
        
    }
    
    //MARK:- Page Functions
    
    @objc func handleDismiss() {
        dismiss(animated: true, completion: nil)
    }
}
